document.addEventListener('DOMContentLoaded', function () {
  const header = document.getElementById('mainHeader');
  const navbar = header.querySelector('.navbar');

  // Crear botón hamburguesa
  const toggleBtn = document.createElement('button');
  toggleBtn.className = 'hamburger-btn';
  toggleBtn.setAttribute('aria-label', 'Abrir menú');
  toggleBtn.innerHTML = '<i class="fas fa-bars"></i>';
  navbar.appendChild(toggleBtn);

  // Clonar enlaces y redes
  const navLinksOriginal = header.querySelector('.nav-links');
  const socialLinksOriginal = header.querySelector('.social-links');

  const navLinksClone = document.createElement('div');
  navLinksClone.className = 'mobile-nav-links';
  navLinksClone.innerHTML = navLinksOriginal.innerHTML;

  const socialLinksClone = document.createElement('div');
  socialLinksClone.className = 'mobile-social-links';
  socialLinksClone.innerHTML = socialLinksOriginal.innerHTML;

  // Crear menú móvil (dropdown)
  const mobileMenu = document.createElement('div');
  mobileMenu.className = 'mobile-menu';
  mobileMenu.appendChild(navLinksClone);
  mobileMenu.appendChild(socialLinksClone);
  navbar.appendChild(mobileMenu);

  // Abrir/Cerrar menú con animación y pintar header
  toggleBtn.addEventListener('click', function (e) {
    e.stopPropagation();
    const abierto = mobileMenu.classList.toggle('open');
    header.classList.toggle('menu-open', abierto);
  });

  // Cerrar al hacer clic fuera
  document.addEventListener('click', function (e) {
    if (!mobileMenu.contains(e.target) && !toggleBtn.contains(e.target)) {
      mobileMenu.classList.remove('open');
      header.classList.remove('menu-open');
    }
  });
});