(() => {
  const questions = [
    {
      text: "¿Cuáles son los ingresos anuales de tu negocio?",
      options: [
        "Menos de $50,000 USD",
        "$50,000–$100,000 USD",
        "$100,000–$250,000 USD",
        "$250,000–$1M USD",
        "$1M–$5M USD",
        "Más de $5M USD"
      ],
      scores: [0,1,2,3,4,5]
    },
    {
      text: "¿Tienes un plan de marketing definido?",
      options: ["Sí","No"],
      scores: [5,0]
    },
    {
      text: "¿Mides tus métricas de venta mensualmente?",
      options: ["Sí","No"],
      scores: [5,0]
    }
    // …puedes añadir más preguntas aquí
  ];

  const openBtn   = document.getElementById("open-test-btn");
  const modal     = document.getElementById("test-modal");
  const closeBtn  = document.getElementById("test-close");
  const progressEl= document.getElementById("test-progress");
  const questionEl= document.getElementById("test-question");
  const optionsEl = document.getElementById("test-options");

  let current = 0, totalScore = 0;

  function renderProgress() {
    progressEl.innerHTML = "";
    questions.forEach((_, i) => {
      const dot = document.createElement("div");
      dot.className = "step" + (i === current ? " active" : "");
      progressEl.appendChild(dot);
    });
  }

  function renderQuestion() {
    const q = questions[current];
    questionEl.textContent = q.text;
    optionsEl.innerHTML = "";
    q.options.forEach((opt, i) => {
      const btn = document.createElement("button");
      btn.className = "test-option-btn";
      btn.textContent = opt;
      btn.addEventListener("click", () => {
        totalScore += q.scores[i];
        current++;
        if (current < questions.length) {
          renderProgress();
          renderQuestion();
        } else {
          showResult();
        }
      });
      optionsEl.appendChild(btn);
    });
  }

  function showResult() {
    let msg;
    if (totalScore <= 5) msg = "Aún necesitas fortalecer tu energia.";
    else if (totalScore <= 10) msg = "Vas por buen camino, sigue optimizando.";
    else msg = "¡Tu negocio está listo para exandirse!";
    optionsEl.innerHTML = `<div class="test-result">${msg}</div>`;
    questionEl.textContent = "¡Test terminado!";
    renderProgress();
  }

  function openModal(e) {
    e.preventDefault();
    current = 0;
    totalScore = 0;
    renderProgress();
    renderQuestion();
    modal.classList.add("active");
  }

  function closeModal() {
    modal.classList.remove("active");
    // limpia el contenido para el próximo inicio
    optionsEl.innerHTML = "";
  }

  openBtn.addEventListener("click", openModal);
  closeBtn.addEventListener("click", closeModal);
})();