<?php include __DIR__.'/../templates/header.php'; ?>
<main>
  <section class="page-under-construction">
    <style>
      html, body {
        height: 100%;
      }
      body {
        min-height: 100vh;
        display: flex;
        flex-direction: column;
      }
      main {
        flex: 1 0 auto;
      }
      .footer-min {
        flex-shrink: 0;
      }
      .page-under-construction {
        min-height: 65vh;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: flex-start;
        background: linear-gradient(120deg, #f7f7f8 0%, #f1f2f3 100%);
        color: #35373c;
        text-align: center;
        padding: 6vw 4vw 3vw 4vw;
        margin-top: 4vw;
      }
      .page-under-construction .icon-wrapper {
        margin-bottom: 2rem;
        background: #b4b9be;
        border-radius: 50%;
        padding: 2.2rem;
        box-shadow: 0 8px 40px 0 #c6c7ca33;
        display: inline-block;
      }
      .page-under-construction h1 {
        color: #22262b;
        font-weight: 900;
        font-size: 2.7rem;
        letter-spacing: -0.04em;
        margin: 2.3rem 0 1.1rem 0;
      }
      .page-under-construction p {
        color: #53575C;
        font-size: 1.19rem;
        max-width: 520px;
        margin: 0 auto 2.6rem auto;
        line-height: 1.45;
      }
      .page-under-construction .btn-go-back {
        background: #4682B4;               /* SteelBlue */
        color: #fff;
        font-size: 1.12rem;
        font-weight: 700;
        padding: 0.88em 2.8em;
        border-radius: 8px;
        text-decoration: none;
        transition: box-shadow 0.16s, background 0.22s, color 0.22s;
        box-shadow: 0 2px 8px rgba(32, 78, 116, 0.1);
        display: inline-block;
        border: none;
        margin-bottom: 1rem;
      }

      .page-under-construction .btn-go-back:hover {
        background: #355A94;               /* SteelBlue más oscuro */
        color: #fff;
        box-shadow: 0 6px 20px rgba(53, 87, 140, 0.2);
      }
      
      @media (max-width: 700px) {
        .page-under-construction {
          padding: 13vw 2vw 4vw 2vw;
          margin-top: 8vw;
        }
        .page-under-construction h1 { font-size: 1.3rem; }
        .page-under-construction p { font-size: 1rem; }
        .page-under-construction .icon-wrapper { padding: 1.1rem; }
      }
    </style>
    <div class="icon-wrapper">
      <svg width="78" height="78" fill="none" xmlns="http://www.w3.org/2000/svg">
        <circle cx="39" cy="39" r="36" stroke="#53575C" stroke-width="4" fill="#F7F7F8"/>
        <path d="M25 52L39 26L53 52" stroke="#53575C" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
        <path d="M39 43V52" stroke="#53575C" stroke-width="3" stroke-linecap="round"/>
      </svg>
    </div>
    <h1>Página en proceso</h1>
    <p>Estamos trabajando para traerte esta sección muy pronto.<br>
      Vuelve a visitarnos en breve.</p>
    <a href="#" class="btn-go-back" onclick="history.back(); return false;">
      Volver atrás
    </a>
  </section>
</main>
<?php include __DIR__.'/../templates/footer.php'; ?>
