<?php 
include __DIR__.'/../templates/header.php';

$section = $_GET['section'] ?? '';
$item    = $_GET['item']    ?? '';

$secciones = [
  'libros' => [
    'items' => [
      'ebook' => [
        'title'       => 'EBOOK: El Útero y el Sol',
        'description' => '<em>El Útero y el Sol</em> es …',
        'priceLabel'  => '$12 USD',
        'priceValue'  => '12.00'
      ]
    ]
  ],
  'servicios' => [
    'items' => [
      'paquete3' => [
        'title'       => 'Paquete 3 sesiones (1h30)',
        'description' => 'Incluye 3 encuentros de 1h30 …',
        'priceLabel'  => '$399 USD',
        'priceValue'  => '399.00'
      ],
      'paquete6' => [
        'title'       => 'Paquete 6 sesiones (1h30)',
        'description' => 'Incluye 6 encuentros de 1h30 …',
        'priceLabel'  => '$590 USD',
        'priceValue'  => '590.00'
      ],
    ]
  ],
  'escuela' => [
    'items' => [
      'formacion1' => [
        'title'       => 'EL PODER DE TU MEDICINA',
        'description' => 'Descubre el potencial de tus dones, aprendiendo a conectar y reconocer …',
        'priceLabel'  => '$87 USD',
        'priceValue'  => '87.00'
      ],
      'formacion2' => [
        'title'       => 'MUJER MEDICINA EMPRESARIA',
        'description' => 'Conviértete en una empresaria consciente y construye un negocio …',
        'priceLabel'  => '$99 USD',
        'priceValue'  => '99.00'
      ],
      'formacion3' => [
        'title'       => 'FINANZAS CONSCIENTES',
        'description' => 'Conoce el sistema que te ayudará a elevar tu economía …',
        'priceLabel'  => '$73 USD',
        'priceValue'  => '73.00'
      ],
      'formacion4' => [
        'title'       => 'EL PODER DE LA SAHUMA',
        'description' => 'Conviértete en una experta en limpieza energética. Descubre …',
        'priceLabel'  => '$79 USD',
        'priceValue'  => '79.00'
      ],
      'formacion5' => [
        'title'       => 'MUJER CACAO',
        'description' => 'Conviértete en Guía de Ceremonias de Cacao. Aprende a sostener …',
        'priceLabel'  => '$142 USD',
        'priceValue'  => '142.00'
      ],
      'formacion6' => [
        'title'       => 'GUARDIANA DEL ÚTERO',
        'description' => 'Conviértete en Guía de Sanaciones de Útero. Aprende a liberar memorias …',
        'priceLabel'  => '$157 USD',
        'priceValue'  => '157.00'
      ],
      // más cursos…
    ]
  ],
  // más secciones…
];

// 3) valida sección e ítem
if (! isset($secciones[$section]['items'][$item])) {
  echo "<p>Opción inválida. <a href='/{$section}'>Volver</a></p>";
  include __DIR__ . '/../templates/footer.php';
  exit;
}

$data = $secciones[$section]['items'][$item];
?>

<main class="pago-section">
  <div class="pago-card">
    <h1 class="pago-title"><?= $data['title'] ?></h1>
    <p class="pago-desc"><?= $data['description'] ?></p>
    <div class="pago-price">Precio: <strong><?= $data['priceLabel'] ?></strong></div>
    
    <!-- Aquí iría tu integración real de pago (Stripe, PayPal, etc.) -->
    <form action="/checkout.php" method="POST" class="pago-form">
      <input type="hidden" name="section" value="<?= htmlspecialchars($section) ?>">
      <input type="hidden" name="amount" value="<?= htmlspecialchars($data['priceValue']) ?>">
      <!-- Campo por ejemplo de email -->
      <label for="email">Tu correo:</label>
      <input type="email" name="email" id="email" required>
      
      <button type="submit" class="btn-pago">
        Pagar <?= $data['priceLabel'] ?>
      </button>
    </form>
      <!-- bloque de JS para alerta -->
      <script>
        document.querySelector('.pago-form').addEventListener('submit', function(e) {
          e.preventDefault(); // detiene el envío real
          // alerta personalizada
          window.alert(
            "🚧 ¡Ups!\n\n" +
            "Por el momento los pagos aún no están habilitados. \n" +
            "Estamos trabajando para que pronto puedas completar tu compra aquí.\n\n" +
            "¡Gracias por tu paciencia!"
          );
        });
      </script>
  </div>
</main>

<?php include __DIR__.'/../templates/footer.php'; ?>